#include <iostream>
#include <vector>
#include <set>
#include <map>
#include <algorithm>
#include <string>
#include <iomanip>
#include <cmath>

using namespace std;
typedef long long ll;
typedef long double ld;
#define int long long
#define endl '\n'

const ld EPS = 1e-9;

bool eq(const ld& a, const ld& b)
{
	return abs(a - b) <= EPS;
}

bool ls(const ld& a, const ld& b)
{
	return a < b && !eq(a, b);
}

bool lq(const ld& a, const ld& b)
{
	return a < b || eq(a, b);
}

struct p
{
	ld x, y;

	p(ld x, ld y) : x(x), y(y) {}

	p() {} 

	bool operator<(const p& b) const
	{
		return eq(x, b.x) ? ls(y, b.y) : ls(x, b.x);
	}
};

const int N = 4010;

int n;

istream& operator>>(istream& cin, p& a)
{
	return cin >> a.x >> a.y;
}

pair <p, p> a[N];

map <p, vector <p>> g;

ld operator*(const p& a, const p& b)
{
	return a.x * b.y - a.y * b.x;
}

ld operator%(const p& a, const p& b)
{
	return a.x * b.x + a.y * b.y;
}

p operator-(const p& a, const p& b)
{
	return p(a.x - b.x, a.y - b.y);
}

p operator+(const p& a, const p& b)
{
	return p(a.x + b.x, a.y + b.y);
}

ld sz(const p& a)
{
	return sqrt(a.x * a.x + a.y * a.y);
}

ld dst(const p& a, const p& u, const p& v)
{
	if (lq(0, (v - u) % (a - u)) && lq(0, (u - v) % (a - v))) return abs((u - a) * (v - a) / sz((u - v)) / 2);
	return min(sz(u - a), sz(v - a));
}

p operator*(const p& a, const ld& v)
{
	return p(a.x * v, a.y * v);
}

set <p> was;

void dfs(const p& u)
{
	if (was.count(u)) return;
	was.insert(u);

	for (auto v : g[u]) dfs(v);
}

inline void solve()
{
	int n;

	cin >> n;	
	was.clear();
	g.clear();
	for (int i = 1; i <= n; ++i)
	{
		cin >> a[i].first >> a[i].second;
	}

	for (int i = 1; i <= n; ++i)
	{
		vector <p> all;
		for (int j = 1; j <= n; ++j) if (i != j)
		{/*
			int e = (a[i].first - a[j].first) * (a[j].second - a[j].first);
			int p = (a[i].second - a[j].first) * (a[j].second - a[j].first);

			int r = (a[j].first - a[i].first) * (a[i].second - a[i].first);
			int s = (a[j].second - a[i].first) * (a[i].second - a[i].first);

			bool ok = */

			auto v1 = a[i].second - a[i].first;
			ld len = sz(v1);

			ld l = 0, r = len;

			while (r - l >= EPS)
			{
				ld m1 = l + (r - l) / 3;
				ld m2 = r - (r - l) / 3;

				auto p1 = a[i].first + v1 * (m1 / len);
				auto p2 = a[i].first + v1 * (m2 / len);

				auto d1 = dst(p1, a[j].first, a[j].second);
				auto d2 = dst(p2, a[j].first, a[j].second);

				if (d1 < d2)
				{
					r = m2;
				}
				else
				{
					l = m1;
				}
			}
			auto p1 = a[i].first + v1 * (l / len);
			if (eq(0, dst(p1, a[j].first, a[j].second)))
			{
				all.push_back(p1);
			}
		}

		sort(all.begin(), all.end());

		for (int i = 0; i + 1 < all.size(); ++i)
		{
			g[all[i]].push_back(all[i + 1]);
			g[all[i + 1]].push_back(all[i]);
		}
	}

	int V = g.size();
	int E = 0;
	for (auto& u : g) E += u.second.size();

	E /= 2;
	int cmps = 0;

	for (auto i : g)
	{
		if (was.count(i.first)) continue;
		++cmps;
		dfs(i.first);
	}

	int ans = 3 + E - V - cmps;
	cout << ans << endl;
}

signed main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	int t;
	cin >> t;
	while (t--)
	{
		solve();
	}

	return 0;
}